import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    "Let's take you to the main page": {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: "Let's take you to the main page",
        ru: 'Давайте вернем вас на страницу, которая точно есть',
        cs: 'Pojďme na hlavní stránku',
    },
    'There is no such page': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'There is no such page',
        ru: 'Такой страницы нет',
        cs: 'Taková stránka neexistuje',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
