import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Bad Gateway': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Bad Gateway',
        ru: 'Ошибка',
        cs: 'Špatná brána',
    },
    'Reload the page': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Reload the page',
        ru: 'Обновить страницу',
        cs: 'Znovu načíst stránku',
    },
    'The site is not working now, try to come back later': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The site is not working now, try to come back later',
        ru: 'Сейчас кабинет не работает, попробуйте зайти позже',
        cs: 'Stránka nyní nefunguje, zkuste se vrátit později',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
