import React from 'react';

import { SupportedLanguage } from 'utils/language/types';

import ErrorView from 'components/ErrorView/index';

import { i18n } from 'components/ErrorView/502/index.i18n';

import Icon from 'components/ErrorView/502/icon.component.svg';

interface IErrorBackendViewProps {
    forceLang?: SupportedLanguage;
    buttonHandler?: () => void;
}

const ErrorBackendView = ({ forceLang, buttonHandler }: IErrorBackendViewProps) => {
    return (
        <ErrorView
            title={i18n('Bad Gateway')}
            buttonHandler={buttonHandler}
            text={i18n('The site is not working now, try to come back later')}
            buttonLabel={i18n('Reload the page')}
            symbol={<Icon />}
        />
    );
};

export default ErrorBackendView;
