import React, { ReactElement } from 'react';
import { useHistory } from 'react-router-dom';

import ControlButton from 'components/ui/Buttons/ControlButton';
import Header1 from 'components/ui/Text/Header1';

import { i18n } from 'components/ErrorView/index.i18n';

import style from 'components/ErrorView/index.css';

interface IErrorViewProps {
    title: string;
    text?: string | ReactElement;
    textComponent?: ReactElement;
    buttonLabel?: string;
    buttonHandler?: () => void;
    symbol: JSX.Element;
    customControls?: ReactElement;
}

const ErrorView = (props: IErrorViewProps) => {
    let { title, text, symbol, buttonLabel, buttonHandler, customControls, textComponent } = props;
    let history = useHistory();

    const onButtonClick = () => {
        if (buttonHandler) {
            buttonHandler();
        } else {
            history.push('/');
        }
    };

    return (
        <div className={style.not_founded_view}>
            <div className={style.info}>
                <div className={style.text_info}>
                    <Header1>{title}</Header1>
                    {textComponent || <span className={style.description}>{text}</span>}
                </div>
                {customControls || (
                    <ControlButton
                        title={buttonLabel ?? i18n('To the main page')}
                        onClick={onButtonClick}
                    />
                )}
            </div>
            <div className={style.symbol}>{symbol}</div>
        </div>
    );
};

export default ErrorView;
