/// <reference types="@yandex-int/jsapi-v2-types/ymaps" />
/// <reference types='webdriverio/async' />
declare module '*.css';
declare module '*.svg';

type Dict<T = string> = Record<string, T>;
type Nullable<T> = T | null;
type Optional<T> = T | undefined;
type Nullish<T> = T | undefined | null;

type OptionalRecord<T> = { [P in keyof T]: Optional<T[P]> };

type SvgIcon = React.FunctionComponent<React.SVGAttributes<SVGElement>>;

/**
 * @typedef Without
 *
 * Takes two record types `T` and `U`, and outputs a new type where the keys
 * are `keyof T - keyof U` and the values are `undefined | never`.
 *
 * Meant to be used as one operand of a product type to produce an XOR type.
 */
type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

/**
 * Takes two record types `T` and `U`, and produces a new type that allows only
 * the keys of T without U or the keys of U without T.
 */
type XOR<T, U> = T | U extends object ? (Without<T, U> & U) | (Without<U, T> & T) : T | U;

/**
 * Simplify syntax for `XOR<A, XOR<B, XOR<C, D>>>` to `OneOf<[A, B, C, D]>`
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
type OneOf<T extends any[]> = T extends [infer Only]
    ? Only
    : T extends [infer First, infer Second, ...infer Rest]
    ? OneOf<[XOR<First, Second>, ...Rest]>
    : never;

// -----
interface AssertViewOptsConfig {
    ignoreElements: string | Array<string>;
    captureElementFromTop: boolean;
    allowViewportOverflow: boolean;
}

declare namespace WebdriverIO {
    interface Browser {
        getMeta(): Promise<Hermione.BrowserMeta>;
        getMeta(key: string): Promise<unknown>;

        setMeta(key: string, value: unknown): Promise<void>;

        extendOptions(opts: { [name: string]: unknown }): Promise<void>;

        assertView(state: string, selectors: string | Array<string>, opts?: AssertViewOpts): Promise<void>;
    }
}
