import React from 'react';

import { ErrorLoggerSource, logError } from 'shared/helpers/errorLogger/errorLogger';

import ErrorLabel from 'components/ui/ErrorLabel';

import style from 'components/GlobalErrorHandler/index.css';

interface IGlobalErrorHandlerState {
    hasError: boolean;
    errorInfo: React.ErrorInfo | null;
}

export default class GlobalErrorHandler extends React.Component<
    { children: React.ReactNode },
    IGlobalErrorHandlerState
> {
    state: IGlobalErrorHandlerState = {
        hasError: false,
        errorInfo: null,
    };

    componentDidCatch(error: Error, info: React.ErrorInfo) {
        logError(ErrorLoggerSource.ERROR_BOUNDARY, error, info);

        this.setState({
            hasError: true,
            errorInfo: info,
        });
    }

    render() {
        let { children } = this.props;
        let { hasError } = this.state;

        if (!hasError) {
            return children;
        }

        return (
            <div>
                <ErrorLabel className={style.errorLabel} />
            </div>
        );
    }
}

export const withErrorHandler = (Component: React.ComponentType) => {
    return (props) => (
        <GlobalErrorHandler>
            <Component {...props} />
        </GlobalErrorHandler>
    );
};

export class ErrorHandler extends React.Component {
    state = {
        error: null,
    };

    componentDidCatch(error: Error, errorInfo: React.ErrorInfo) {
        console.warn(error);
        this.setState({ error });
    }

    render() {
        return !this.state.error && this.props.children;
    }
}
