import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Back: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Back',
        ru: 'Назад',
        cs: 'Zpět',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
