import React from 'react';
import { useHistory, useLocation } from 'react-router-dom';

import { MODAL_BACK } from 'constants/constants';

import { i18n } from 'components/GlobalSidebar/GlobalSidebarHeader.i18n';

import Back from 'components/GlobalSidebar/back.component.svg';

import style from 'components/GlobalSidebar/index.css';

export const GlobalSidebarHeader = (props) => {
    let history = useHistory();
    let { children, backAction } = props;
    let location = useLocation();
    let urlSearchParams = new URLSearchParams(location?.search);
    let showBack = urlSearchParams.has(MODAL_BACK) && history.length > 1;

    const onBackClick = () => {
        if (backAction) {
            backAction();
        } else {
            history.goBack();
        }
    };

    return (
        <div className={style.header}>
            {backAction || showBack ? (
                <div
                    className={`${style.back} ${style.block}`}
                    onClick={onBackClick}
                >
                    <Back className={style.back_icon} />
                    <span>{i18n('Back')}</span>
                </div>
            ) : null}
            <div className={`${style.title} ${style.block}`}>{children}</div>
        </div>
    );
};
