import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Maximum battery level to trigger the signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Maximum battery level to trigger the signal',
        ru: 'Максимальный уровень заряда АКБ для срабатывания сигнала',
        cs: 'Maximální úroveň nabití baterie pro spuštění signálu',
    },
    'Maximum charge level': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Maximum charge level',
        ru: 'Максимальный уровень заряда',
        cs: 'Maximální úroveň nabití',
    },
    'Minimum battery level to trigger the signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Minimum battery level to trigger the signal',
        ru: 'Минимальный уровень заряда АКБ для срабатывания сигнала',
        cs: 'Minimální úroveň nabití baterie pro spuštění signálu',
    },
    'Minimum charge level': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Minimum charge level',
        ru: 'Минимальный уровень заряда',
        cs: 'Minimální úroveň nabití',
    },
    V: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'V',
        ru: 'В',
        cs: 'V',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
