import React, { useState } from 'react';

import { Input } from 'components/ui/Input';

import { i18n } from 'components/GlobalSidebar/ModalAddSignal/CarBatterySignalForm/index.i18n';

import style from 'components/GlobalSidebar/ModalAddSignal/CarBatterySignalForm/index.css';

const CarBatterySignalForm = ({ onChange }: { onChange: (values: any) => void }) => {
    const [carBatteryMinValue, setCarBatteryMinValue] = useState<string>('');
    const [carBatteryMaxValue, setCarBatteryMaxValue] = useState<string>('');

    function triggerChange(carBatteryMinValue: string, carBatteryMaxValue: string) {
        onChange({
            min_voltage: carBatteryMinValue ? Number(carBatteryMinValue) : 0,
            max_voltage: carBatteryMaxValue ? Number(carBatteryMaxValue) : 0,
        });
    }

    const onMinValueChange = (carBatteryMinValue: string) => {
        setCarBatteryMinValue(carBatteryMinValue);
        triggerChange(carBatteryMinValue, carBatteryMaxValue);
    };

    const onMaxValueChange = (carBatteryMaxValue: string) => {
        setCarBatteryMaxValue(carBatteryMaxValue);
        triggerChange(carBatteryMinValue, carBatteryMaxValue);
    };

    return (
        <div>
            <div className={style.carbattery_input}>
                <div className={style.info}>
                    <span className={style.title}>{i18n('Minimum charge level')}</span>
                    <span className={style.description}>{i18n('Minimum battery level to trigger the signal')}</span>
                </div>
                <div className={style.input_container}>
                    <Input
                        value={carBatteryMinValue}
                        onChange={onMinValueChange}
                        measure={i18n('V')}
                    />
                </div>
            </div>
            <div className={style.carbattery_input}>
                <div className={style.info}>
                    <span className={style.title}>{i18n('Maximum charge level')}</span>
                    <span className={style.description}>{i18n('Maximum battery level to trigger the signal')}</span>
                </div>
                <div className={style.input_container}>
                    <Input
                        value={carBatteryMaxValue}
                        onChange={onMaxValueChange}
                        measure={i18n('V')}
                    />
                </div>
            </div>
        </div>
    );
};

export default CarBatterySignalForm;
