import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Diagnostic error codes (comma separated)': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Diagnostic error codes (comma separated)',
        ru: 'Коды ошибок диагностики. Перечислять через запятую.',
        cs: 'Diagnostické chybové kódy (oddělené čárkou)',
    },
    'Error codes': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Error codes',
        ru: 'Коды ошибок',
        cs: 'Chybové kódy',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
