import React, { useState } from 'react';

import { TextareaSize } from 'shared/consts/TextareaSize';
import { Textarea } from 'shared/ui/Textarea/Textarea';

import { i18n } from 'components/GlobalSidebar/ModalAddSignal/DiagnosticSignalForm/index.i18n';

import style from 'components/GlobalSidebar/ModalAddSignal/DiagnosticSignalForm/index.css';

const DiangosticSignalForm = ({ onChange }: { onChange: (values: any) => void }) => {
    const [dtcCodes, setDtcCodes] = useState<string[]>(['']);

    const onCodesChange = (event: React.ChangeEvent<HTMLTextAreaElement>) => {
        const nextValue = event.target.value.replace(/'/g, '').split(',');
        setDtcCodes(nextValue);
        onChange({
            dtc: nextValue ? nextValue : [],
        });
    };

    return (
        <div>
            <div className={style.dtc_code_input}>
                <div className={style.info}>
                    <span className={style.title}>{i18n('Error codes')}</span>
                    <span className={style.description}>{i18n('Diagnostic error codes (comma separated)')}</span>
                </div>
            </div>
            <div className={style.input_container}>
                <Textarea
                    expandable
                    textareaSize={TextareaSize.M}
                    value={dtcCodes.join(',')}
                    onChange={onCodesChange}
                />
            </div>
        </div>
    );
};

export default DiangosticSignalForm;
