import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '°C': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: '°C',
        ru: '°C',
        cs: '°C',
    },
    'Min temperature': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Min temperature',
        ru: 'Мин температура',
        cs: 'Min. teplota',
    },
    'Minimal engine temperature': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Minimal engine temperature',
        ru: 'Минимальная температура двигателя',
        cs: 'Min. teplota motoru',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
