import * as React from 'react';
import cn from 'classnames';

import { useForm } from 'shared/hooks/useForm/useForm';

import { Input } from 'components/ui/Input';

import { i18n } from 'components/GlobalSidebar/ModalAddSignal/EngineOverheatingSignalForm/EngineOverheatingSignalForm.i18n';

import styles from 'components/GlobalSidebar/ModalAddSignal/EngineOverheatingSignalForm/EngineOverheatingSignalForm.css';

export interface EngineOverheatingSignalFormProps {
    className?: string;
    onChange(values: any): void;
}

interface EngineOverheatingSignalFormSchema {
    min_temp: string;
    max_temp: number;
}

const DEFAULT_MAX_TEMP = 150;

const INIT: OptionalRecord<EngineOverheatingSignalFormSchema> = {
    max_temp: DEFAULT_MAX_TEMP,
    min_temp: undefined,
};

function str2num(val: Optional<string>): Optional<number> {
    const num = Number(val);
    
return !val || isNaN(num) ? undefined : num;
}

export const EngineOverheatingSignalForm: React.FC<EngineOverheatingSignalFormProps> =
    function EngineOverheatingSignalForm({ className, onChange }) {
        const onFormChange = React.useCallback(
            (values: OptionalRecord<EngineOverheatingSignalFormSchema>) => {
                const minTemp = str2num(values.min_temp);

                onChange(
                    minTemp
                        ? {
                              max_temp: values.max_temp,
                              min_temp: minTemp,
                          }
                        : {},
                );
            },
            [onChange],
        );

        const { update, watch } = useForm<OptionalRecord<EngineOverheatingSignalFormSchema>>({
            init: { ...INIT },
            validation: {},
            onFormChange,
        });

        return (
            <div className={cn(styles, className)}>
                <div className={styles.form_input}>
                    <div className={styles.info}>
                        <span className={styles.title}>{i18n('Min temperature')}</span>
                        <span className={styles.description}>{i18n('Minimal engine temperature')}</span>
                    </div>
                    <div className={styles.input_container}>
                        <Input
                            value={String(watch('min_temp') || '')}
                            onChange={update('min_temp')}
                            measure={i18n('°C')}
                        />
                    </div>
                </div>
            </div>
        );
    };
