import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Choose groups': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Choose groups',
        ru: 'Выберите группы',
        cs: 'Vyberte skupiny',
    },
    Groups: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Groups',
        ru: 'Группы',
        cs: 'Skupiny',
    },
    'Groups have not been created yet, they can be configured in the section': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Groups have not been created yet, they can be configured in the section',
        ru: 'Группы ещё не созданы, их можно настроить в разделе',
        cs: 'Skupiny zatím nebyly vytvořeny, lze je nakonfigurovat v části',
    },
    'No groups available': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'No groups available',
        ru: 'Нет доступных групп',
        cs: 'Nejsou k dispozici žádné skupiny',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
