import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Car groups': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car groups',
        ru: 'Группы машин',
        cs: 'Skupiny vozů',
    },
    "The signal will be triggered on the selected car groups. If you don't choose, then on all cars.": {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: "The signal will be triggered on the selected car groups. If you don't choose, then on all cars.",
        ru: 'Сигнал будет срабатывать на выбранные группы машин. Если не выбирать — то на все.',
        cs: 'Signál se spustí u vybraných skupin vozidel. Pokud neprovedete výběr, pak na všech autech.',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
