import React from 'react';

import { useCarsGroups } from 'entities/Car/api/useCarsGroups/useCarsGroups';

import { ErrorBoundary } from 'shared/ui/ErrorBoundary/ErrorBoundary';
import { Spin } from 'shared/ui/Spin/Spin';

import { GroupSignalFormList } from 'components/GlobalSidebar/ModalAddSignal/GroupSignalForm/GroupSignalFormList';

import { i18n } from 'components/GlobalSidebar/ModalAddSignal/GroupSignalForm/index.i18n';

import style from 'components/GlobalSidebar/ModalAddSignal/GroupSignalForm/index.css';

interface GroupSignalFormProps {
    onChange: (values: { named_filters: { include_dynamic_group: string[] } }) => void;
}

const GroupSignalForm = ({ onChange }: GroupSignalFormProps) => {
    const carsGroups = useCarsGroups();

    return (
        <>
            <div className={style.form_input}>
                <div className={style.info}>
                    <span className={style.title}>{i18n('Car groups')}</span>
                    <span className={style.description}>
                        {i18n(
                            "The signal will be triggered on the selected car groups. If you don't choose, then on all cars.",
                        )}
                    </span>
                </div>
            </div>
            {/*TODO: Error message*/}
            <ErrorBoundary fallback={<div>Error :(</div>}>
                <React.Suspense
                    fallback={
                        <div className={style.form_input}>
                            <Spin />
                        </div>
                    }
                >
                    <GroupSignalFormList
                        onChange={onChange}
                        resource={carsGroups}
                    />
                </React.Suspense>
            </ErrorBoundary>
        </>
    );
};

export default GroupSignalForm;
