import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Check interval': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Check interval',
        ru: 'Интервал проверки',
        cs: 'Interval kontroly',
    },
    d: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'd',
        ru: 'д',
        cs: 'd',
    },
    'In how many days': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: 'In how many days',
        ru: 'За какое количество дней',
        cs: 'Za kolik dní',
    },
    km: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'km',
        ru: 'км',
        cs: 'km',
    },
    'Minimum overmileage in km to trigger the signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Minimum overmileage in km to trigger the signal',
        ru: 'Минимальный километраж перепробега для срабатывания',
        cs: 'Minimální počet ujetých kilometrů nad limit (v km) pro spuštění signálu',
    },
    Overmileage: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Overmileage',
        ru: 'Перепробег',
        cs: 'Počet ujetých kilometrů nad limit',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
