import React, { useState } from 'react';

import { Input } from 'components/ui/Input';

import { i18n } from 'components/GlobalSidebar/ModalAddSignal/OvermileageSignalForm/index.i18n';

import style from 'components/GlobalSidebar/ModalAddSignal/OvermileageSignalForm/index.css';

const OvermileageSignalForm = ({ onChange }: { onChange: (values: any) => void }) => {
    const [mileage, setMileage] = useState<string>('');
    const [intervalDays, setIntervalDays] = useState<string>('');

    function triggerChange(mileage: string, intervalDays: string) {
        onChange({
            mileage: mileage ? Number(mileage) : 0,
            interval_days: intervalDays ? Number(intervalDays) : 0,
        });
    }

    const onMileageChange = (mileage: string) => {
        setMileage(mileage);
        triggerChange(mileage, intervalDays);
    };

    const onIntervalDaysChange = (intervalDays: string) => {
        setIntervalDays(intervalDays);
        triggerChange(mileage, intervalDays);
    };

    return (
        <div>
            <div className={style.form_input}>
                <div className={style.info}>
                    <span className={style.title}>{i18n('Overmileage')}</span>
                    <span className={style.description}>{i18n('Minimum overmileage in km to trigger the signal')}</span>
                </div>
                <div className={style.input_container}>
                    <Input
                        value={mileage}
                        onChange={onMileageChange}
                        measure={i18n('km')}
                    />
                </div>
            </div>
            <div className={style.form_input}>
                <div className={style.info}>
                    <span className={style.title}>{i18n('Check interval')}</span>
                    <span className={style.description}>{i18n('In how many days')}</span>
                </div>
                <div className={style.input_container}>
                    <Input
                        value={intervalDays}
                        onChange={onIntervalDaysChange}
                        measure={i18n('d')}
                    />
                </div>
            </div>
        </div>
    );
};

export default OvermileageSignalForm;
