import React from 'react';

import Arrow from 'components/GlobalSidebar/ModalAddSignal/SignalCard/arrow.component.svg';

import style from 'components/GlobalSidebar/ModalAddSignal/SignalCard/index.css';

interface ISignalCardProps {
    title: string;
    description?: string;
    onClick: () => void;
}

const SignalCard = ({ title, description, onClick }: ISignalCardProps) => {
    return (
        <div
            className={style.signal_card}
            onClick={onClick}
        >
            <div className={style.info}>
                <span className={style.title}>{title}</span>
                <span className={style.description}>{description}</span>
            </div>
            <div className={style.arrow}>
                <Arrow />
            </div>
        </div>
    );
};

export default SignalCard;
