import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Exceeding threshold': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Exceeding threshold',
        ru: 'Порог превышения',
        cs: 'Překročení limitu',
    },
    'How much you can exceed the speed inside the zone (0 - no limit)': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'How much you can exceed the speed inside the zone (0 - no limit)',
        ru: 'На сколько можно превысить скорость внутри зоны (0 - без ограничений)',
        cs: 'O kolik můžete překročit rychlost v rámci zóny (0 – bez omezení)',
    },
    'km/h': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'km/h',
        ru: 'км/ч',
        cs: 'km/h',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
