import React, { useState } from 'react';

import { Input } from 'components/ui/Input';

import { i18n } from 'components/GlobalSidebar/ModalAddSignal/SpeedingSignalForm/index.i18n';

import style from 'components/GlobalSidebar/ModalAddSignal/SpeedingSignalForm/index.css';

const SpeedingSignalForm = ({ onChange }: { onChange: (values: any) => void }) => {
    const [overspeedValue, setOverspeedValue] = useState<string>('');

    const onOverspeedChange = (overspeedValue: string) => {
        setOverspeedValue(overspeedValue);
        onChange({ speed_threshold: overspeedValue ? +overspeedValue : 0 });
    };

    return (
        <div className={style.overspeed_input}>
            <div className={style.info}>
                <span className={style.title}>{i18n('Exceeding threshold')}</span>
                <span className={style.description}>
                    {i18n('How much you can exceed the speed inside the zone (0 - no limit)')}
                </span>
            </div>
            <div className={style.input_container}>
                <Input
                    value={overspeedValue}
                    onChange={onOverspeedChange}
                    measure={i18n('km/h')}
                />
            </div>
        </div>
    );
};

export default SpeedingSignalForm;
