import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'How long after the last telematics data update the signal will be generated': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'How long after the last telematics data update the signal will be generated',
        ru: 'Через какое время после последнего обновления данных телематики будет создан сигнал',
        cs: 'Jak dlouho po poslední aktualizaci dat telematiky bude generován signál',
    },
    min: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'min',
        ru: 'мин',
        cs: 'min',
    },
    'Time since last update': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Time since last update',
        ru: 'Время после последнего обновления',
        cs: 'Doba od poslední aktualizace',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
