import React, { useState } from 'react';

import { SECONDS_IN_MINUTE } from 'constants/constants';

import { Input } from 'components/ui/Input';

import { i18n } from 'components/GlobalSidebar/ModalAddSignal/TelematicsLagSignalForm/index.i18n';

import style from 'components/GlobalSidebar/ModalAddSignal/TelematicsLagSignalForm/index.css';

const TelematicsLagSignalForm = ({ onChange }: { onChange: (values: any) => void }) => {
    const [activationThreshold, setActivationThreshold] = useState<string>('');

    const onActivationThresholdChange = (activationThreshold: string) => {
        setActivationThreshold(activationThreshold);
        onChange({
            activation_threshold: activationThreshold ? +activationThreshold * SECONDS_IN_MINUTE : 0,
        });
    };

    return (
        <div className={style.form_input}>
            <div className={style.info}>
                <span className={style.title}>{i18n('Time since last update')}</span>
                <span className={style.description}>
                    {i18n('How long after the last telematics data update the signal will be generated')}
                </span>
            </div>
            <div className={style.input_container}>
                <Input
                    value={activationThreshold}
                    onChange={onActivationThresholdChange}
                    measure={i18n('min')}
                />
            </div>
        </div>
    );
};

export default TelematicsLagSignalForm;
