import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Choose geofence': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Choose geofence',
        ru: 'Выберите геозону',
        cs: 'Vyberte zonu',
    },
    'Choose geofence for vehicle leaving control': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Choose geofence for vehicle leaving control',
        ru: 'Выберите зону для контроля выезда',
        cs: 'Vyberte zónu pro ovládání výjezdu auta',
    },
    'Failed to load geofences': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Failed to load geofences',
        ru: 'Не удалось загрузить зоны',
        cs: 'Načtení zón se nezdařilo',
    },
    Geofences: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Geofences',
        ru: 'Зоны',
        cs: 'Zóny',
    },
    'Geofences have not been created yet, they can be configured in the section': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Geofences have not been created yet, they can be configured in the section',
        ru: 'Зоны ещё не созданы, их можно настроить в разделе',
        cs: 'Zóny ještě nebyly vytvořeny, lze je konfigurovat v sekci',
    },
    'No geofences available': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'No geofences available',
        ru: 'Нет доступных зон',
        cs: 'Nejsou k dispozici žádné zóny',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
