import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Create signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Create signal',
        ru: 'Создать сигнал',
        cs: 'Vytvořit signál',
    },
    'Creating a new signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Creating a new signal',
        ru: 'Создание нового сигнала',
        cs: 'Vytváření nového signálu',
    },
    Critical: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Critical',
        ru: 'Критический',
        cs: 'Kritické',
    },
    'Go to the signal settings section': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Go to the signal settings section',
        ru: 'Перейти в раздел настройки сигналов',
        cs: 'Přejít do části nastavení signálu',
    },
    Normal: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Normal',
        ru: 'Обычный',
        cs: 'Normální',
    },
    Settings: {
        _meta: {
            context: 'Signals settings',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Settings',
        ru: 'Настройка',
        cs: 'Nastavení',
    },
    'Signal created': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal created',
        ru: 'Сигнал создан',
        cs: 'Signál vytvořen',
    },
    'Signal name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal name',
        ru: 'Название сигнала',
        cs: 'Název signálu',
    },
    'Signal priority': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal priority',
        ru: 'Уровень сигнала',
        cs: 'Priorita signálu',
    },
    'The selected signal type determines the settings that can be applied to it.': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The selected signal type determines the settings that can be applied to it.',
        ru: 'От выбранного типа сигнала зависит те настройки, которые можно будет применить к нему.',
        cs: 'Vybraný typ signálu určuje nastavení, která lze pro něj aplikovat.',
    },
    'The signal priority affects the style of signal display in the signal center, as well as the signal sorting parameters.':
        {
            _meta: {
                status: {
                    en: 'APPROVED',
                    ru: 'REQUIRES_TRANSLATION',
                    cs: 'APPROVED',
                },
            },
            en: 'The signal priority affects the style of signal display in the signal center, as well as the signal sorting parameters.',
            ru: 'Уровень сигнала влияет на стиль отображения сигнала в сигнальном центре, а также на параметры сортировки сигналов',
            cs: 'Priorita signálu ovlivňuje styl zobrazení signálu v signálním centru a také parametry řazení signálu.',
        },
    'Type selection': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Type selection',
        ru: 'Выбор типа',
        cs: 'Výběr typu',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
