import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add driver': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Add driver',
        ru: 'Добавить водителя',
        cs: 'Přidat řidiče',
    },
    Driver: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Driver',
        ru: 'Водитель',
        cs: 'Řidič',
    },
    'Failed to create user': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Failed to create user',
        ru: 'Не удалось создать пользователя',
        cs: 'Vytvoření uživatele se nezdařilo',
    },
    'Go to Users section': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Go to Users section',
        ru: 'Перейти в раздел «Пользователи»',
        cs: 'Přejít do části Uživatelé',
    },
    'Responsible for access to the admin panel and application': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Responsible for access to the admin panel and application',
        ru: 'Отвечают за доступы к админке и приложению',
        cs: 'Odpovídá za přístup k panelu správce a aplikaci',
    },
    'User is created': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User is created',
        ru: 'Пользователь успешно создан',
        cs: 'Uživatel je vytvořen',
    },
    'User roles': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User roles',
        ru: 'Роли пользователя',
        cs: 'Role uživatele',
    },
    'User with this phone number already exists': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User with this phone number already exists',
        ru: 'Есть пользователь с таким номером телефона',
        cs: 'Uživatel s tímto telefonním číslem již existuje',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
