import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'All cars will lose their connection to this group': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'All cars will lose their connection to this group',
        ru: 'Все машины потеряют привязку к этой группе',
        cs: 'Všechny vozy ztratí spojení s touto skupinou',
    },
    'Are you sure you want to delete the group?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Are you sure you want to delete the group?',
        ru: 'Точно хотите удалить группу?',
        cs: 'Opravdu chcete odstranit skupinu?',
    },
    Cancel: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cancel',
        ru: 'Отменить',
        cs: 'Zrušit',
    },
    'Cars:': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cars:',
        ru: 'Машин:',
        cs: 'Vozy:',
    },
    'Yes, delete': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Yes, delete',
        ru: 'Да, удалить',
        cs: 'Ano, odstranit',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
