import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'A group with the same name already exists': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'A group with the same name already exists',
        ru: 'Группа с таким названием уже существует',
        cs: 'Skupina se stejným názvem již existuje',
    },
    'All cars will lose their connection to this group': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'All cars will lose their connection to this group',
        ru: 'Все машины потеряют привязку к этой группе',
        cs: 'Všechny vozy ztratí spojení s touto skupinou',
    },
    Cars: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cars',
        ru: 'Машины',
        cs: 'Vozy',
    },
    'Delete group': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delete group',
        ru: 'Удалить группу',
        cs: 'Odstranit skupinu',
    },
    Description: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Description',
        ru: 'Описание',
        cs: 'Popis',
    },
    'Group name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Group name',
        ru: 'Название группы',
        cs: 'Název skupiny',
    },
    'No cars found': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'No cars found',
        ru: 'Машины не найдены',
        cs: 'Nebyly nalezeny žádné vozy',
    },
    'Save changes': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Save changes',
        ru: 'Сохранить изменения',
        cs: 'Uložit změny',
    },
    Settings: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Settings',
        ru: 'Настройки',
        cs: 'Nastavení',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
