import React from 'react';
import { useHistory } from 'react-router-dom';

import { formatCarModel } from 'entities/Car';

import { CarNumberLabel } from 'components/Cars/CarNumberLabel';
import { ISearchCar } from 'components/GlobalSidebar/ModalSearchView/index';

import ArrowIcon from 'components/GlobalSidebar/ModalSearchView/SearchResults/SearchResultRow/arrow.component.svg';

import style from 'components/GlobalSidebar/ModalSearchView/index.css';

interface ISearchResultRowProps {
    car: ISearchCar;
}

const SearchResultRow = ({ car }: ISearchResultRowProps) => {
    let { id, model_id } = car;
    let numberCarInfo: any = car;
    const history = useHistory();

    const onClick = () => {
        history.push(`/cars/${id}`);
    };

    return (
        <tr
            key={id}
            onClick={onClick}
        >
            <td>{formatCarModel(model_id)}</td>
            <td>
                <CarNumberLabel carInfo={{ number: numberCarInfo.number }} />
            </td>
            <td>
                <CarNumberLabel carInfo={{ vin: numberCarInfo.vin }} />
            </td>
            <td>
                <div className={style.arrow_container}>
                    <ArrowIcon />
                </div>
            </td>
        </tr>
    );
};

export default SearchResultRow;
