import React from 'react';

import { ISearchCar } from 'components/GlobalSidebar/ModalSearchView/index';
import SearchResultRow from 'components/GlobalSidebar/ModalSearchView/SearchResults/SearchResultRow';

import { i18n } from 'components/GlobalSidebar/ModalSearchView/SearchResults/index.i18n';

import style from 'components/GlobalSidebar/ModalSearchView/index.css';

export interface ISearchResultsProps {
    searchResults: ISearchCar[];
    isSearching: boolean;
    withoutTypeLabels?: boolean;
}

const SearchResults = ({ searchResults, isSearching, withoutTypeLabels }: ISearchResultsProps) => {
    return (
        <div className={style.search_results}>
            {isSearching && searchResults.length ? <div className={style.searching_overlay} /> : null}
            {withoutTypeLabels ? null : (
                <div className={style.entity_title}>
                    <span className={style.title}>{i18n('Cars')}</span>
                    <span className={style.count}>{searchResults?.length}</span>
                </div>
            )}

            <table className={style.search_result_table}>
                <tbody>
                    {searchResults?.map((car) => {
                        return (
                            <SearchResultRow
                                key={car.id}
                                car={car}
                            />
                        );
                    })}
                </tbody>
            </table>
        </div>
    );
};

export default SearchResults;
