import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Please enter at least 3 characters to search': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Please enter at least 3 characters to search',
        ru: 'Введите хотя бы 3 символа для поиска',
        cs: 'Zadejte nejméně 3 znaky pro vyhledávání',
    },
    'Too short search request': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Too short search request',
        ru: 'Слишком короткий запрос',
        cs: 'Příliš krátký požadavek na vyhledávání',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
