import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Bad Gateway': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Bad Gateway',
        ru: 'Ошибка',
        cs: 'Špatná brána',
    },
    'Permission denied': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: 'Permission denied',
        ru: 'Ошибка доступа',
        cs: 'Povolení zamítnuto',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
