import React from 'react';

import shortDateTime from 'utils/date/shortDateTime';

import Image, { IImageProps } from 'components/ui/Image';
import Main2 from 'components/ui/Text/Main2';

import styles from 'components/GlobalSidebar/ModalSessionView/SessionPhotos/index.css';

interface ISectionPhotoRow {
    date?: string;
    images: IImageProps[];
    onClick?: (index: number) => void;
}

const SectionPhotoRow = (props: ISectionPhotoRow) => {
    let { date, images, onClick } = props;

    return (
        <div>
            <div className={styles.container_text}>
                <Main2 className={styles.date}>{date}</Main2>
            </div>
            <div className={styles.container_images}>
                {images?.map((img, index) => {
                    return (
                        <Image
                            src={img.src}
                            onClick={onClick?.bind(null, index)}
                            key={index}
                        />
                    );
                })}
            </div>
        </div>
    );
};

interface ISectionPhotoRowItem {
    data: any[];
    onClick?: (index: number | null) => void;
}

const SectionPhotoRowItem = ({ data, onClick }: ISectionPhotoRowItem) => {
    return (
        <SectionPhotoRow
            date={shortDateTime(data?.[0]?.created_at)}
            images={data?.map((img) => ({ src: img.url }))}
            onClick={onClick}
        />
    );
};
export { SectionPhotoRowItem };

export default SectionPhotoRow;
