import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Current car position': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Current car position',
        ru: 'Машина сейчас здесь',
        cs: 'Aktuální poloha vozu',
    },
    'Dangerous maneuver': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dangerous maneuver',
        ru: 'Небезопасный  манёвр',
        cs: 'Nebezpečný manévr',
    },
    'Harsh acceleration': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Harsh acceleration',
        ru: 'Резкое ускорение',
        cs: 'Prudké zrychlení',
    },
    'Harsh braking': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Harsh braking',
        ru: 'Резкое торможение',
        cs: 'Prudké brzdění',
    },
    'Harsh lane change': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Harsh lane change',
        ru: 'Резкое перестроение',
        cs: 'Prudká změna jízdního pruhu',
    },
    'Harsh turn': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Harsh turn',
        ru: 'Резкий поворот',
        cs: 'Prudké zatočení',
    },
    'Ride finish': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Ride finish',
        ru: 'Конец поездки',
        cs: 'Dokončení jízdy',
    },
    'Ride start': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Ride start',
        ru: 'Начало поездки',
        cs: 'Zahájení jízdy',
    },
    'Speeding: +{value} km/h': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Speeding: +{value} km/h',
        ru: 'Превышение скорости: +{value} км/ч',
        cs: 'Překročení rychlosti: +{value} km/h',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
