import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{value} km/h': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: '{value} km/h',
        ru: '{value} км/ч',
        cs: '{value} km/h',
    },
    Events: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Events',
        ru: 'События',
        cs: 'Události',
    },
    Photos: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Photos',
        ru: 'Фотографии',
        cs: 'Fotografie',
    },
    Ride: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Ride',
        ru: 'Поездка',
        cs: 'Jízda',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
