import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Are you sure you want to delete the signal?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Are you sure you want to delete the signal?',
        ru: 'Точно хотите удалить сигнал?',
        cs: 'Opravdu chcete odstranit signál?',
    },
    Cancel: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cancel',
        ru: 'Отменить',
        cs: 'Zrušit',
    },
    'If you delete the signal, its history will disappear as well and you will not be able to recreate it with the same name':
        {
            _meta: {
                status: {
                    en: 'APPROVED',
                    ru: 'TRANSLATED',
                    cs: 'APPROVED',
                },
            },
            en: 'If you delete the signal, its history will disappear as well and you will not be able to recreate it with the same name',
            ru: 'Если удалить сигнал, то история его срабатываний исчезнет и пересоздать его с таким же именем не получится',
            cs: 'Pokud signál odstraníte, zmizí i jeho historie a nebudete jej moci znovu vytvořit se stejným názvem',
        },
    'Yes, delete': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Yes, delete',
        ru: 'Да, удалить',
        cs: 'Ano, odstranit',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
