import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Delete signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delete signal',
        ru: 'Удалить сигнал',
        cs: 'Odstranit signál',
    },
    'If you delete the signal, its history will disappear as well and you will not be able to recreate it with the same name':
        {
            _meta: {
                status: {
                    en: 'APPROVED',
                    ru: 'TRANSLATED',
                    cs: 'APPROVED',
                },
            },
            en: 'If you delete the signal, its history will disappear as well and you will not be able to recreate it with the same name',
            ru: 'Если удалить сигнал, то история его срабатываний исчезнет и пересоздать его с таким же именем не получится',
            cs: 'Pokud signál odstraníte, zmizí i jeho historie a nebudete jej moci znovu vytvořit se stejným názvem',
        },
    'If you disable the signal, then events of this type will not be shown in the signal center': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'If you disable the signal, then events of this type will not be shown in the signal center',
        ru: 'Если отключить сигнал, то события с данным типом не будут показываться в сигнальном центре',
        cs: 'Pokud signál deaktivujete, události tohoto typu se nezobrazí v signálním centru',
    },
    Signal: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal',
        ru: 'Сигнал',
        cs: 'Signál',
    },
    'Signal settings': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal settings',
        ru: 'Настройки сигнала',
        cs: 'Nastavení signálu',
    },
    'Turn on the signal': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Turn on the signal',
        ru: 'Включить сигнал',
        cs: 'Zapněte signál',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
