import React from 'react';
import { useHistory } from 'react-router-dom';

import Arrow from 'components/GlobalSidebar/ModalSignalView/SignalEntityBlock/arrow.component.svg';

import style from 'components/GlobalSidebar/ModalSignalView/SignalEntityBlock/index.css';

interface ISignalEntityBlockProps {
    title: string;
    children: any;
    link: string;
}

const SignalEntityBlock = ({ title, link, children }: ISignalEntityBlockProps) => {
    let history = useHistory();

    const onClick = () => {
        history.push(link);
    };

    return (
        <div
            className={style.signal_entity_block}
            onClick={onClick}
        >
            <div className={style.title}>{title}</div>
            {children}
            <div className={style.arrow_container}>
                <div className={style.arrow}>
                    <Arrow />
                </div>
            </div>
        </div>
    );
};

export default SignalEntityBlock;
