import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Car: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car',
        ru: 'Машина',
        cs: 'Vůz',
    },
    'Car is blocked': {
        _meta: {
            context: 'Signal name',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car is blocked',
        ru: 'Блокировка машины',
        cs: 'Vůz je zablokován',
    },
    'Leaving geofence': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Leaving geofence',
        ru: 'Выезд из зоны',
        cs: 'Opuštění zóny',
    },
    Ride: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Ride',
        ru: 'Поездка',
        cs: 'Jízda',
    },
    'Telematics lag': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Telematics lag',
        ru: 'Лаг телематики',
        cs: 'Zpoždění telematiky',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
