import { IEntityObject } from 'components/Signals/SignalsTable';

export const buildSignalInfoString = (since: number, entitiesObject: IEntityObject) => {
    return (
        `${since}` +
        `${entitiesObject.car ? `_car=${entitiesObject.car?.object_id}` : ''}` +
        `${entitiesObject.trace ? `_trace=${entitiesObject.trace?.object_id}` : ''}`
    );
};

export interface ISignalInfo {
    since: number;
    car?: string | null;
    trace?: string | null;
}

export const getSignalInfoFromString = (signalInfoString: string | null) => {
    if (!signalInfoString) {
        return null;
    }

    let [since, ...entities] = signalInfoString?.split('_');
    let result: ISignalInfo = entities.reduce(
        (result, entity) => {
            let [entityType, entityId] = entity.split('=');
            result[entityType] = entityId;

            return result;
        },
        { since: +since },
    );

    return result;
};
