import * as React from 'react';

import Header4 from 'components/ui/Text/Header4';

import styles from 'components/GlobalSidebar/ModalUpsertCarView/FormStep/index.css';

interface IFormStepProps {
    step: number;
    title: string;
    description?: string;
    disabled?: boolean;
}

export const FormStep = (props: React.PropsWithChildren<IFormStepProps>) => {
    let { children, step, title, description, disabled } = props;

    return (
        <div className={styles.formStep}>
            <div className={`${styles.formStepDescription} ${disabled ? styles.disabled : ''}`}>
                <span className={styles.step}>{step}</span>
                <div className={styles.info}>
                    <Header4 className={styles.title}>{title}</Header4>
                    {description ? <p className={styles.description}>{description}</p> : null}
                </div>
            </div>
            {children}
        </div>
    );
};
