import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Add car',
        ru: 'Добавить машину',
        cs: 'Přidat vůz',
    },
    'Additional information': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Additional information',
        ru: 'Дополнительная информация',
        cs: 'Další informace',
    },
    'Basic information': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Basic information',
        ru: 'Базовая информация',
        cs: 'Základní informace',
    },
    'Car can be created after filling in these fields': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: 'Car can be created after filling in these fields',
        ru: 'Машину можно уже создать после заполнения этих полей',
        cs: 'Vůz lze vytvořit po vyplnění těchto polí',
    },
    'Car has already been created, filling in these fields is required to show all data on the car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: 'Car has already been created, filling in these fields is required to show all data on the car',
        ru: 'Машина уже создана, эти поля надо заполнить, чтобы показывать все данные по машине',
        cs: 'Vůz byl již vytvořen, vyplnění těchto polí je nutné pro zobrazení všech dat o vozu',
    },
    'Create car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Create car',
        ru: 'Создать машину',
        cs: 'Vytvořit vůz',
    },
    'Edit car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Edit car',
        ru: 'Редактирование машины',
        cs: 'Upravit vůz',
    },
    'Error while editing car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Error while editing car',
        ru: 'Ошибка при редактировании машины',
        cs: 'Chyba při úpravě vozu',
    },
    'Error while loading car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: 'Error while loading car',
        ru: 'Не получилось загрузить данные машины',
        cs: 'Chyba při načítání vozu',
    },
    'General information': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'General information',
        ru: 'Основная информация',
        cs: 'Obecné informace',
    },
    IMEI: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'IMEI',
        ru: 'IMEI',
        cs: 'IMEI',
    },
    'License plate number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'License plate number',
        ru: 'Регистрационный номер',
        cs: 'Číslo registrační značky',
    },
    Model: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Model',
        ru: 'Модель',
        cs: 'Model',
    },
    'Save changes': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Save changes',
        ru: 'Сохранить изменения',
        cs: 'Uložit změny',
    },
    'Telematics data': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Telematics data',
        ru: 'Данные телематики',
        cs: 'Data telematiky',
    },
    VIN: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'VIN',
        ru: 'VIN',
        cs: 'VIN',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
