import React from 'react';

import Confirm from 'components/ui/Confirm';

import { i18n } from 'components/GlobalSidebar/ModalUserView/BlockUserConfirmModal/index.i18n';

interface IBlockUserConfirmModalProps {
    title: string;
    onConfirm: () => void;
    onClose: () => void;
    isLoading: boolean;
    error: Error | null;
    confirmButtonTitle: string;
}

const BlockUserConfirmModal = (props: IBlockUserConfirmModalProps) => {
    let { title, onConfirm, onClose, isLoading, error, confirmButtonTitle } = props;

    return (
        <Confirm
            title={title}
            confirmButtonTitle={confirmButtonTitle}
            closeButtonTitle={i18n('No')}
            onConfirm={onConfirm}
            onClose={onClose}
            isLoading={isLoading}
            error={error}
        />
    );
};

export default BlockUserConfirmModal;
