import React from 'react';

import Confirm from 'components/ui/Confirm';

import { i18n } from 'components/GlobalSidebar/ModalUserView/DeleteUserConfirmModal/index.i18n';

interface IDeleteUserConfirmModalProps {
    onConfirm: () => void;
    onClose: () => void;
    isLoading: boolean;
    error: Error | null;
}

const DeleteUserConfirmModal = (props: IDeleteUserConfirmModalProps) => {
    let { onConfirm, onClose, isLoading, error } = props;

    return (
        <Confirm
            title={i18n('Delete user?')}
            confirmButtonTitle={i18n('Yes, delete')}
            closeButtonTitle={i18n('No')}
            onConfirm={onConfirm}
            onClose={onClose}
            isLoading={isLoading}
            error={error}
        />
    );
};

export default DeleteUserConfirmModal;
