import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'E-mail': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'E-mail',
        ru: 'E-mail',
        cs: 'E-mail',
    },
    'Middle name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Middle name',
        ru: 'Отчество',
        cs: 'Prostřední jméno',
    },
    Name: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Name',
        ru: 'Имя',
        cs: 'Jméno',
    },
    'Personal data': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Personal data',
        ru: 'Личные данные',
        cs: 'Osobní údaje',
    },
    Phone: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Phone',
        ru: 'Телефон',
        cs: 'Telefon',
    },
    Surname: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Surname',
        ru: 'Фамилия',
        cs: 'Příjmení',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
