import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Block user': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Block user',
        ru: 'Заблокировать',
        cs: 'Blokovat uživatele',
    },
    'Block user?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Block user?',
        ru: 'Заблокировать пользователя?',
        cs: 'Zablokovat uživatele?',
    },
    'Delete user': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Delete user',
        ru: 'Удалить пользователя',
        cs: 'Odstranit uživatele',
    },
    'E-mail': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'E-mail',
        ru: 'E-mail',
        cs: 'E-mail',
    },
    'Failed to change user': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Failed to change user',
        ru: 'Не удалось изменить пользователя',
        cs: 'Změna uživatele se nezdařila',
    },
    'Last rides': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Last rides',
        ru: 'Последние поездки',
        cs: 'Poslední jízdy',
    },
    Phone: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Phone',
        ru: 'Телефон',
        cs: 'Telefon',
    },
    'Responsible for access to the admin panel and application': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Responsible for access to the admin panel and application',
        ru: 'Отвечают за доступы к админке и приложению',
        cs: 'Odpovídá za přístup k panelu správce a aplikaci',
    },
    Rides: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Rides',
        ru: 'Поездки',
        cs: 'Jízdy',
    },
    'Save changes': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Save changes',
        ru: 'Сохранить изменения',
        cs: 'Uložit změny',
    },
    Settings: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Settings',
        ru: 'Настройки',
        cs: 'Nastavení',
    },
    'The user will get access to the application': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The user will get access to the application',
        ru: 'Пользователь получит доступ к приложению',
        cs: 'Uživatel získá přístup k aplikaci',
    },
    'The user will lose all access forever': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The user will lose all access forever',
        ru: 'Пользователь потеряет все доступы навсегда',
        cs: 'Uživatel navždy ztratí veškerý přístup',
    },
    'The user will not be able to use the application': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'The user will not be able to use the application',
        ru: 'Пользователь не сможет пользоваться приложением',
        cs: 'Uživatel nebude moci aplikaci používat',
    },
    'Unblock user': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Unblock user',
        ru: 'Разблокировать',
        cs: 'Odblokovat uživatele',
    },
    'Unblock user?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Unblock user?',
        ru: 'Разблокировать пользователя?',
        cs: 'Odblokovat uživatele?',
    },
    'User changed successfully': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User changed successfully',
        ru: 'Пользователь успешно изменён',
        cs: 'Uživatel byl úspěšně změněn',
    },
    'User has no roles': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User has no roles',
        ru: 'У пользователя нету ролей',
        cs: 'Uživatel nemá žádné role',
    },
    'User is blocked': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User is blocked',
        ru: 'Пользователь заблокирован',
        cs: 'Uživatel je zablokován',
    },
    'User is deleted': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User is deleted',
        ru: 'Пользователь удалён',
        cs: 'Uživatel je odstraněn',
    },
    'User is unblocked': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User is unblocked',
        ru: 'Пользователь разблокирован',
        cs: 'Uživatel je odblokován',
    },
    'User roles': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User roles',
        ru: 'Роли пользователя',
        cs: 'Role uživatele',
    },
    'User with this phone number already exists': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'User with this phone number already exists',
        ru: 'Есть пользователь с таким номером телефона',
        cs: 'Uživatel s tímto telefonním číslem již existuje',
    },
    'Yes, block': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Yes, block',
        ru: 'Да, заблокировать',
        cs: 'Ano, zablokovat',
    },
    'Yes, unblock': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Yes, unblock',
        ru: 'Да, разблокировать',
        cs: 'Ano, odblokovat',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
