import * as React from 'react';
import { Story } from '@storybook/react';

import Informer, { CharType, DashedLabel, IInformerProps, InformersGrid } from 'components/Informer/index';
import { buildScoringAdditionalData } from 'components/Scoring/ScoringInformer/buildScoringAdditionalData';
import { buildScoringChartOptions } from 'components/Scoring/ScoringInformer/buildScoringChartOptions';

export default { title: 'Informers (Charts)' };

const Template: Story<IInformerProps> = (args) => <Informer {...args} />;

export const Informer_without_data = Template.bind({});
Informer_without_data.args = {
    data: [],
    isLoading: false,
    type: 'line',
    title: 'МОТОЧАСЫ',
    value: 10,
    additionalHeaders: [null, <DashedLabel key={0} />],
};

export const informer_with_data = Template.bind({});
informer_with_data.args = {
    data: [
        { x: '16.09', y: 10 },
        { x: '17.09', y: 30 },
        { x: '18.09', y: 6 },
    ],
    isLoading: false,
    type: 'line',
    title: 'МОТОЧАСЫ',
    value: 5.4,
    additionalHeaders: [<DashedLabel key={0} />],
};

export const scoring_informer = () => {
    let data = [
        { x: '13.09', y: 5 },
        { x: '14.09', y: 0.5 },
        { x: '15.09', y: 5 },
        { x: '16.09', y: 7.5 },
    ];

    let additional_data = [
        { x: '13.09', y: 5.1 },
        { x: '14.09', y: 4 },
        { x: '15.09', y: 7.6 },
        { x: '16.09', y: 5.1 },
    ];
    let label = 'Скоринг';

    return (
        <div style={{ width: '550px' }}>
            <Informer
                data={data}
                description={label}
                options={buildScoringChartOptions()}
                additionalDatasets={[buildScoringAdditionalData({ data: additional_data, label: 'Среднее' })]}
                type={CharType.line}
                title={label}
                isLoading={false}
                additionalHeaders={[<DashedLabel key={0} />]}
                value={7.5}
            />
        </div>
    );
};

export const few_charts = () => {
    return (
        <InformersGrid>
            <Informer
                data={[]}
                type={CharType.line}
                title="test"
                isLoading={false}
                value={20}
            />

            <Informer
                data={[]}
                type={CharType.line}
                title="test"
                isLoading={false}
                value={10}
            />
        </InformersGrid>
    );
};
