import React from 'react';

import styles from 'components/Map/controls/Cluster/index.css';

interface ICluster {
    count: number | string;
    warningCars: number | string;
    customOptions?: {
        badgeSize?: string;
        clusterSize?: string;
    };
}

export const badgeSize = {
    large: 'large',
    common: 'common',
};

export const clusterSize = {
    large: 'large',
    common: 'common',
};

export const Cluster = (props: ICluster) => {
    let { count, warningCars, customOptions } = props;

    return (
        <div
            className={styles.cluster}
            data-cluster-size={customOptions?.clusterSize}
        >
            <div className={styles.cluster_count}>{count}</div>
            <div
                data-badge={warningCars}
                data-badge-size={customOptions?.badgeSize}
                className={`${styles.cluster_count_warning}`}
            >
                {warningCars}
            </div>
        </div>
    );
};
