import React from 'react';

import { ICarInfo } from 'utils/car/types';

import { StatusTypes } from 'components/types';

import styles from 'components/Map/controls/GPSPinIconLayout/index.css';

interface IPinIconLayout {
    car: ICarInfo;
    isWarning?: boolean;
    className?: string;
    hovered?: boolean;
}

export const GPSPinIconLayout = (props: IPinIconLayout) => {
    const DEG_180 = 180;
    let { car, isWarning, className = '', hovered = false } = props;
    let { status } = car ?? {};
    let isNoSignalCar = status === StatusTypes.NO_SIGNAL;
    let angle = `${(+car?.location?.course || 0) + DEG_180}deg`;
    let telematics = car?.telematics;
    let isMove = telematics?.is_engine_on && telematics?.speed;

    return (
        <div className={`${styles.pin_wrapper} ${hovered ? styles.hovered : ''} ${className}`}>
            <div className={`${styles.pin} ${isNoSignalCar ? styles.no_signal : ''}`}>
                {isWarning && <div className={styles.war_pin} />}
            </div>
            {isMove && !isNoSignalCar ? (
                <div
                    className={styles.car_front}
                    style={{
                        transform: `rotate(${angle})`,
                        transformOrigin: '12px 0',
                    }}
                />
            ) : null}
        </div>
    );
};
